<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pabellon extends Model
{
    use HasFactory;

    protected $table = 'pabellones';
    protected $primaryKey = 'id';

    protected $fillable = [
        'nombre',
        'descripcion',
    ];

    /**
     * Un pabellón tiene muchas aulas
     */
    public function aulas()
    {
        return $this->hasMany(Aula::class, 'id_pabellon');
    }
}
