<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Usuario extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $table = 'usuarios'; // Nombre de la tabla

    protected $primaryKey = 'id'; // Clave primaria

    public $timestamps = true; // Laravel usará created_at y updated_at automáticamente

    protected $fillable = [
        'username', 'password_hash', 'status', 'img'
    ];

    protected $hidden = [
        'password_hash',
    ];

    public function getAuthPassword()
    {
        return $this->password_hash; // Indicar a Laravel qué campo usar como password
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'usuario_roles', 'usuario_id', 'rol_id');
    }

    /**
     * Relación con el docente (si el usuario tiene un docente asociado).
     */
    public function docente()
    {
        return $this->hasOne(Docente::class, 'usuario_id');
    }

    public function administrador()
    {
        return $this->hasOne(Administrador::class, 'usuario_id');
    }

    public function estudiante()
    {
        return $this->hasOne(Postulante::class, 'usuario_id');
    }

    // Usuario.php
public function getNombreCompletoAttribute()
{
    $roles = $this->roles->pluck('nombre')->toArray();

    if (in_array('Administrador', $roles) && $this->administrador) {
        return $this->administrador->nombre . ' ' . $this->administrador->apellido;
    } elseif (in_array('Docente', $roles) && $this->docente) {
        return $this->docente->nombre . ' ' . $this->docente->apellido;
    } elseif (in_array('Estudiante', $roles) && $this->estudiante) {
        return $this->estudiante->nombres . ' ' . $this->estudiante->apellidos;
    }

    return $this->username;
}
// Usuario.php
public function areas()
{
    return $this->belongsToMany(Area::class, 'usuario_areas')
                ->withTimestamps()
                ->withPivot('activo');
}


}
