@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Docentes @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
            <div class="card mb-4">
            <form id="formPerfil" method="POST">
    @csrf

    {{-- Datos personales --}}
    <div class="card mb-4 shadow-sm border-0">
        <div class="card-header bg-primary text-white">
            <i class="bi bi-person-circle me-2"></i>Datos Personales
        </div>
        <div class="card-body">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="nombre" class="form-label"><i class="bi bi-person-fill"></i> Nombre</label>
                    <input type="text" name="nombre" value="{{ old('nombre', $docente->nombre) }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="apellido" class="form-label"><i class="bi bi-person-lines-fill"></i> Apellido</label>
                    <input type="text" name="apellido" value="{{ old('apellido', $docente->apellido) }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="dni" class="form-label"><i class="bi bi-credit-card-2-front-fill"></i> DNI</label>
                    <input type="text" name="dni" value="{{ $docente->dni }}" class="form-control" readonly>
                </div>

                <div class="col-md-6">
                    <label for="email" class="form-label"><i class="bi bi-envelope-fill"></i> Email</label>
                    <input type="email" name="email" value="{{ old('email', $docente->email) }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="telefono" class="form-label"><i class="bi bi-telephone-fill"></i> Teléfono</label>
                    <input type="text" name="telefono" value="{{ old('telefono', $docente->telefono) }}" class="form-control">
                </div>

                <div class="col-md-6">
                    <label for="direccion" class="form-label"><i class="bi bi-geo-alt-fill"></i> Dirección</label>
                    <input type="text" name="direccion" value="{{ old('direccion', $docente->direccion) }}" class="form-control">
                </div>

                
            </div>

        </div>
    </div>

    {{-- Cambio de contraseña --}}
    <div class="card mb-4 shadow-sm border-0">
        <div class="card-header bg-secondary text-white">
            <i class="bi bi-key-fill me-2"></i>Cambiar Contraseña
        </div>
        <div class="card-body">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="password" class="form-label"><i class="bi bi-lock-fill"></i> Nueva Contraseña</label>
                    <input type="password" name="password" id="password" class="form-control">
                    @error('password') <div class="text-danger mt-1">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label for="password_confirmation" class="form-label"><i class="bi bi-lock"></i> Confirmar Contraseña</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control">
                </div>
            </div>

        </div>
    </div>

    <div class="text-end">
        <button type="submit" class="btn btn-success px-4">
            <i class="bi bi-save-fill me-1"></i> Guardar Cambios
        </button>
    </div>
</form>

                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
document.getElementById('formPerfil').addEventListener('submit', function(e) {
    e.preventDefault();

    let form = this;
    let formData = new FormData(form);

    fetch("{{ route('docente.actualizar-perfil') }}", {
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: formData
    })
    .then(response => {
        if (!response.ok) throw response;
        return response.json();
    })
    .then(data => {
        Swal.fire({
            icon: 'success',
            title: 'Éxito',
            text: data.message || 'Perfil actualizado correctamente'
        });
    })
    .catch(async error => {
        let msg = 'Ocurrió un error al guardar';

        if (error.status === 422) {
            const err = await error.json();
            msg = Object.values(err.errors).flat().join('\n');
        }

        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: msg
        });
    });
});
</script>









@endsection
